# Supplementary Code: Generalization Bounds via \( V_\alpha \)

This repository provides the Python and MATLAB code used to generate the simulation figures for our ICLR paper.

**"One Measure, Many Bounds: Bridging TV, Variance, and Mutual Information"**

---

## Overview

This code reproduces all simulation results presented in the paper. It compares the proposed \( V_\alpha \)-based generalization bounds with classical information-theoretic bounds such as the mutual information and conditional mutual information bound.

---

## Figures Reproduced

| Figure | Description |
|--------|-------------|
| **Figure 1** | Trade-off analysis of \( V_\alpha \) vs. MI bound on the Z-channel |
| **Figure 2** | Comparison of generalization bounds in Bayesian linear regression (see corresponding .ipynb)|
| **Figure 3** | BSC channel: \( V_\alpha \) vs. MI for \( \alpha = 2 \) |
| **Figure 4** | BEC channel: \( V_\alpha \) vs. MI for \( \alpha = 2 \) |
| **Figure 5** | Z-channel: \( V_\alpha \) vs. MI for \( \alpha = 2 \) |

Example output (Figure 1):

![Figure 1 Example](./Figure1.png)

---
